<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<?php
// Display Flash Messages - Add this to your view or layout
if ($this->session->flashdata('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle"></i> <?php echo $this->session->flashdata('success'); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if ($this->session->flashdata('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-circle"></i> <?php echo $this->session->flashdata('error'); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if ($this->session->flashdata('warning')): ?>
    <div class="alert alert-warning alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-triangle"></i> <?php echo $this->session->flashdata('warning'); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if ($this->session->flashdata('info')): ?>
    <div class="alert alert-info alert-dismissible fade show" role="alert">
        <i class="fas fa-info-circle"></i> <?php echo $this->session->flashdata('info'); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>



<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <div class="card shadow border-0">
                <div class="card-body p-4 p-md-5">
                    <div class="text-center mb-4">
                        <i class="fas fa-hands-helping fa-3x text-primary mb-3"></i>
                        <h2 class="fw-bold">Volunteer Application</h2>
                        <p class="lead text-muted">Join our team and make a difference!</p>
                    </div>
                    
                    <?php echo form_open_multipart('volunteer/submit', array('id' => 'volunteerForm')); ?>
                        
                        <h5 class="fw-bold mb-3 text-primary">Personal Information</h5>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Full Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="full_name" value="<?php echo set_value('full_name'); ?>" required>
                                <?php echo form_error('full_name', '<small class="text-danger">', '</small>'); ?>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Email <span class="text-danger">*</span></label>
                                <input type="email" class="form-control" name="email" value="<?php echo set_value('email'); ?>" required>
                                <?php echo form_error('email', '<small class="text-danger">', '</small>'); ?>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Phone <span class="text-danger">*</span></label>
                                <input type="tel" class="form-control" name="phone" value="<?php echo set_value('phone'); ?>" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Date of Birth</label>
                                <input type="date" class="form-control" name="date_of_birth" value="<?php echo set_value('date_of_birth'); ?>">
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-bold">Address <span class="text-danger">*</span></label>
                            <textarea class="form-control" name="address" rows="2" required><?php echo set_value('address'); ?></textarea>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">City <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="city" value="<?php echo set_value('city'); ?>" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Country</label>
                                <input type="text" class="form-control" name="country" value="<?php echo set_value('country', 'Ghana'); ?>">
                            </div>
                        </div>
                        
                        <hr class="my-4">
                        
                        <h5 class="fw-bold mb-3 text-primary">Professional Information</h5>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Occupation <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="occupation" value="<?php echo set_value('occupation'); ?>" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Skills <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="skills" value="<?php echo set_value('skills'); ?>" 
                                       placeholder="e.g., Teaching, Event Planning" required>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-bold">Availability <span class="text-danger">*</span></label>
                            <select class="form-select" name="availability" required>
                                <option value="">-- Select --</option>
                                <option value="weekdays" <?php echo set_select('availability', 'weekdays'); ?>>Weekdays</option>
                                <option value="weekends" <?php echo set_select('availability', 'weekends'); ?>>Weekends</option>
                                <option value="flexible" <?php echo set_select('availability', 'flexible'); ?>>Flexible</option>
                            </select>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-bold">Areas of Interest <span class="text-danger">*</span></label>
                            <textarea class="form-control" name="areas_of_interest" rows="3" required><?php echo set_value('areas_of_interest'); ?></textarea>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-bold">Previous Volunteer Experience</label>
                            <textarea class="form-control" name="previous_experience" rows="3"><?php echo set_value('previous_experience'); ?></textarea>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-bold">Why do you want to volunteer? <span class="text-danger">*</span></label>
                            <textarea class="form-control" name="motivation" rows="4" required><?php echo set_value('motivation'); ?></textarea>
                        </div>
                        
                        <hr class="my-4">
                        
                        <h5 class="fw-bold mb-3 text-primary">Emergency Contact</h5>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Contact Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="emergency_contact_name" value="<?php echo set_value('emergency_contact_name'); ?>" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Contact Phone <span class="text-danger">*</span></label>
                                <input type="tel" class="form-control" name="emergency_contact_phone" value="<?php echo set_value('emergency_contact_phone'); ?>" required>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-bold">Profile Photo <small class="text-muted">(Optional)</small></label>
                            <input type="file" class="form-control" name="profile_photo" accept="image/*">
                            <small class="form-text text-muted">JPG, PNG - Max 2MB</small>
                        </div>
                        
                        <div class="d-grid gap-2 mt-4">
                            <button type="submit" class="btn btn-primary btn-lg">
                                <i class="fas fa-check"></i> Submit Application
                            </button>
                        </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>
    </div>
</div>